/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import immersive_armors.armorEffects.ArmorEffect;
import immersive_armors.item.ExtendedArmorMaterial;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class ExtendedArmorItem
extends class_1738 {
    private static final UUID[] MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private Multimap<class_1320, class_1322> attributeModifiers;
    private final ExtendedArmorMaterial material;

    public ExtendedArmorItem(class_1792.class_1793 settings, class_1304 slot, ExtendedArmorMaterial material) {
        super((class_1741)material, slot, settings);
        this.material = material;
        this.refreshAttributes();
    }

    public int method_7687() {
        return this.material.method_7697(this.field_7880);
    }

    public float method_26353() {
        return this.material.method_7700();
    }

    public void refreshAttributes() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uUID = MODIFIERS[this.field_7880.method_5927()];
        builder.put((Object)class_5134.field_23724, (Object)new class_1322(uUID, "Armor modifier", (double)this.method_7687(), class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23725, (Object)new class_1322(uUID, "Armor toughness", (double)this.getMaterial().method_7700(), class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23718, (Object)new class_1322(uUID, "Armor knockback resistance", (double)this.material.method_24355(), class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23719, (Object)new class_1322(uUID, "Armor movement speed", (double)(-this.material.getWeight()), class_1322.class_1323.field_6331));
        builder.put((Object)class_5134.field_23716, (Object)new class_1322(uUID, "Armor health gain", (double)this.material.getExtraHealth(), class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(uUID, "Armor attack bonus", (double)this.material.getAttackDamage(), class_1322.class_1323.field_6331));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(uUID, "Armor attack damage", (double)this.material.getAttackSpeed(), class_1322.class_1323.field_6331));
        builder.put((Object)class_5134.field_23726, (Object)new class_1322(uUID, "Armor luck", (double)this.material.getLuck(), class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == this.field_7880 ? this.attributeModifiers : super.method_7844(slot);
    }

    public ExtendedArmorMaterial getMaterial() {
        return this.material;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        for (ArmorEffect armorEffect : this.getMaterial().getEffects()) {
            armorEffect.appendTooltip(stack, world, tooltip, context);
        }
        for (Map.Entry entry : this.getMaterial().getEnchantments().entrySet()) {
            tooltip.add(((class_1887)entry.getKey()).method_8179(((Integer)entry.getValue()).intValue()));
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1309 livingEntity;
        class_1799 equippedStack;
        super.method_7888(stack, world, entity, slot, selected);
        if (entity instanceof class_1309 && (equippedStack = (livingEntity = (class_1309)entity).method_6118(this.method_7685())) == stack) {
            for (ArmorEffect e : this.getMaterial().getEffects()) {
                e.equippedTick(stack, world, livingEntity, slot);
            }
        }
    }

    public float applyArmorToDamage(class_1309 entity, class_1282 source, float amount, class_1799 armor) {
        for (ArmorEffect e : this.getMaterial().getEffects()) {
            amount = e.applyArmorToDamage(entity, source, amount, armor);
        }
        return amount;
    }

    public float applyArmorToAttack(class_1309 target, class_1282 source, float amount, class_1799 armor) {
        for (ArmorEffect e : this.getMaterial().getEffects()) {
            amount = e.applyArmorToAttack(target, source, amount, armor);
        }
        return amount;
    }
}

